% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\name{withMin}
\alias{withMin}
\alias{withMin,matrix,worldMatrix,missing-method}
\alias{withMin,matrix,worldArray,character-method}
\alias{withMin,agentMatrix,missing,character-method}
\title{\code{Agents} with minimum}
\usage{
withMin(agents, world, var)

\S4method{withMin}{matrix,worldMatrix,missing}(agents, world)

\S4method{withMin}{matrix,worldArray,character}(agents, world, var)

\S4method{withMin}{agentMatrix,missing,character}(agents, var)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{var}{Character. The name of the selected \code{agents} variable.
If \code{agents} are \code{patches} and the \code{world} is a
\code{worldMatrix} object, \code{var} must not be provided. If
\code{agents} are \code{patches} and the \code{world} is a \code{worldArray}
object, \code{var} is the name of the layer to use to define the \code{patches}
values. If \code{agents} are \code{turtles}, \code{var} is one of
the \code{turtles}' variable and can be equal to \code{xcor},
\code{ycor}, any of the variables created when \code{turtles} were created,
as well as any variable created using \code{turtlesOwn()}.}
}
\value{
Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second column
\code{pycor} representing the coordinates of the \code{patches} among the \code{agents}
which have their variable
equal to the minimum value among the \code{agents}, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{    `AgentMatrix` representing the `turtles` among the `agents`
    which have their variable
    `var` equal to the minimum value among the `agents`.
}\if{html}{\out{</div>}}
}
\description{
Report the \code{patches} or \code{turtles} among \code{agents} which have their variable
equals to the minimum value.
}
\details{
\code{world} must not be provided if \code{agents} are turtles.
}
\examples{
# Patches
w1 <- createWorld(
  minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
  data = sample(1:5, size = 25, replace = TRUE)
)
plot(w1)
p1 <- withMin(agents = patches(w1), world = w1)

# Turtles
t1 <- createTurtles(
  n = 10, coords = randomXYcor(w1, n = 10),
  heading = sample(1:3, size = 10, replace = TRUE)
)
t2 <- withMin(agents = t1, var = "heading")

}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#with-min}
}
\author{
Sarah Bauduin
}
