% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mmsbm.R
\name{predict.mmsbm}
\alias{predict.mmsbm}
\title{Predict edges based on estimated mmsbm model}
\usage{
\method{predict}{mmsbm}(
  object,
  new.data.dyad = NULL,
  new.data.monad = NULL,
  parametric_mm = FALSE,
  forecast = FALSE,
  type = c("link", "response"),
  ...
)
}
\arguments{
\item{object}{Object of class \code{mmsbm}.}

\item{new.data.dyad}{An optional \code{data.frame} object.}

\item{new.data.monad}{An optional \code{data.frame} object.}

\item{parametric_mm}{oolean. Should the variational posterior be used for sampling the mixed-memberships (\code{FALSE}), 
or should the mixed-meberships be formed using the parameters in the monadic regression equation (\code{TRUE})?
Defaults to \code{FALSE}. If \code{(new.data.monad | forcast) = TRUE}, setting this to \code{FALSE} will produce an error.}

\item{forecast}{Boolean. Should prediction forcast one step into the future? Defaults to FALSE.}

\item{type}{Character string. The default is to use the linear predictor of edges. The alternative
"response" returns predicted probabilities.}

\item{...}{Currently ignored}
}
\value{
If \code{new.data.dyad = NULL}, vector of length \code{nrow(object$dyadic.data)}. Else, vector of length \code{nrow(new.data.dyad)}.
}
\description{
The function produces expected posterior edges based  
on estimated parameters and (optionally new) predictor data
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  School + Practice + Status,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2,
                      mmsbm.control = list(seed = 123,
                                           hessian = FALSE))

## Get in-sample predicted edge probabilities
lazega_preds <- predict(lazega_mmsbm, type = "response")

}
\author{
Santiago Olivella (olivella@unc.edu), Adeline Lo (aylo@wisc.edu), Tyler Pratt (tyler.pratt@yale.edu), Kosuke Imai (imai@harvard.edu)
}
