% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_LCC.R
\name{extract_LCC}
\alias{extract_LCC}
\title{Extract LCC from a graph}
\usage{
extract_LCC(g)
}
\arguments{
\item{g}{is the graph you want to extract the largest connected component}
}
\value{
a graph (from igraph) with only the largest connected component
}
\description{
Extract LCC from a graph
}
\examples{
set.seed(12)
x = data.frame(n1 = sample(LETTERS[1:5]),
               n2 =  sample(LETTERS[1:20]))

g = igraph::graph_from_data_frame(x, directed = FALSE)
g = igraph::simplify(g)
LCC = extract_LCC(g)


}
