% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_him.R
\name{nd.him}
\alias{nd.him}
\title{HIM Distance}
\usage{
nd.him(A, out.dist = TRUE, xi = 1, ntest = 10)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{xi}{a parameter to control balance between two distances.}

\item{ntest}{the number of searching over \code{\link{nd.csd}} parameter.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
Hamming-Ipsen-Mikhailov (HIM) combines the local Hamming edit distance and the global
Ipsen-Mikhailov distance to merge information at each scale. For Ipsen-Mikhailove distance,
it is provided as \code{nd.csd} in our package for consistency. Given a parameter \eqn{\xi} (\code{xi}),
it is defined as
\deqn{HIM_{\xi}(A,B)=\sqrt{H^2(A,B)+\xi\cdot IM^2(A,B)}/\sqrt{1+\xi}}
where \eqn{H} and \eqn{IM} stand for Hamming and I-M distance, respectively.
}
\examples{
\dontrun{
## load example data
data(graph20)

## compute distance matrix and visualize
output = nd.him(graph20, out.dist=FALSE)
image(output$D[,20:1], main="two group case", axes=FALSE, col=gray(0:32/32))
}

}
\references{
\insertRef{jurman_him_2015}{NetworkDistance}
}
\seealso{
\code{\link{nd.hamming}}, \code{\link{nd.csd}}
}
