% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{impact}
\alias{impact}
\title{Node Impact}
\usage{
impact(A, progBar = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{progBar}{Defaults to FALSE.
Set to TRUE to see progress bar}
}
\value{
A vector of node impact values for each node in the network
(impact > 0, greater ASPL when node is removed; impact < 0, lower ASPL when node is removed)
}
\description{
Computes impact measure or how much the average distance in the network changes with that node removed of each node in a network
(Please see and cite Kenett et al., 2011. See also \code{\link[networktools]{impact}} for a separate but related measure)
}
\examples{
A<-TMFG(neoOpen)$A

nodeimpact<-impact(A)
}
\references{
Kenett, Y. N., Kenett, D. Y., Ben-Jacob, E., & Faust, M. (2011).
Global and local features of semantic networks: Evidence from the Hebrew mental lexicon.
\emph{PloS one}, \emph{6}(8), e23912.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
