% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{reg}
\alias{reg}
\title{Regression Matrix}
\usage{
reg(data, family = c("binomial", "gaussian", "Gamma", "poisson"),
  symmetric = TRUE)
}
\arguments{
\item{data}{A dataset}

\item{family}{Error distribution to be used in the regression model.
Defaults to "logistic".
Set to any family used in function \emph{glm} (see \code{\link{family}})}

\item{symmetric}{Should matrix be symmetric?
Defaults to TRUE, taking the mean of the two edge weights
(i.e., [\emph{i},\emph{j}] and [\emph{j},\emph{i}])
Set to FALSE for asymmwtric weights
(i.e., [\emph{i},\emph{j}] does not equal [\emph{j},\emph{i}])}
}
\value{
A matrix of fully regressed coefficients where one variable is regressed over all others
}
\description{
Computes regression such that one variable is regressed over all other variables
}
\examples{
#binarize responses
psyb <- ifelse(neoOpen>=4, 1, 0)

#perform logistic regression
mat <- reg(psyb)
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
