% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{diversity}
\alias{diversity}
\title{Diversity Coefficient}
\usage{
diversity(A, comm = c("walktrap", "louvain"))
}
\arguments{
\item{A}{Network adjacency matrix}

\item{comm}{A vector of corresponding to each item's community.
Defaults to \code{"walktrap"} for the \code{\link[igraph]{cluster_walktrap}} community detection algorithm.
Set to \code{"louvain"} for the \code{\link[NetworkToolbox]{louvain}} community detection algorithm.
Can also be set to user-specified communities (see examples)}
}
\value{
Returns a list containing:

\item{overall}{Diversity coefficient without signs considered}

\item{positive}{Diversity coefficient with only positive sign}

\item{negative}{Diversity coefficient wih only negative sign}
}
\description{
Computes the diversity coefficient for each node. The diversity
coefficient measures a node's connections to communitites outside of its
own community. Nodes that have many connections to other communities will
have higher diversity coefficient values. Positive and negative signed weights
for diversity coefficients are computed separately.
}
\details{
Values closer to 1 suggest greater between-community connectivity and 
values closer to 0 suggest greater within-community connectivity
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

#theoretical communities
comm <- rep(1:8, each = 6)

gdiv <- diversity(A, comm = comm)

#walktrap communities
wdiv <- diversity(A, comm = "walktrap")

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
