% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.multidimensional.R
\name{node.multidimensional}
\alias{node.multidimensional}
\title{Detects Node Crossings in a Network}
\usage{
node.multidimensional(A, comm, plot = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{A vector or matrix corresponding to the
community each node belongs to}

\item{plot}{Should a plot be produced?}
}
\value{
Produces a list containing:
}
\description{
UNDER DEVELOPMENT.
Computes \code{\link[NetworkToolbox]{rspbc}} for connections
between dimensions in a network. Multidimensional nodes can be detected
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

# Obtain communities via walktrap algorithm
comm <- igraph::walktrap.community(convert2igraph(abs(A)))$membership

\dontrun{
result <- node.multidimensional(A = A, comm = comm$wc, plot = FALSE)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
