% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{estimate}
\alias{estimate}
\title{estimate}
\usage{
estimate(estimator, Z, theta = NULL, use_gpu = TRUE)
}
\arguments{
\item{estimator}{a neural estimator}

\item{Z}{data; format should be amenable to the architecture of \code{estimator}}

\item{theta}{parameter vectors (only for neural estimators that take both the data and parameters as input, e.g., neural ratio estimators)}

\item{use_gpu}{a boolean indicating whether to use the GPU if it is available (default true)}
}
\value{
a matrix of parameter estimates (i.e., \code{estimator} applied to \code{Z})
}
\description{
estimate parameters from observed data using a neural estimator
}
\examples{
\dontrun{
library(NeuralEstimators)
library(JuliaConnectoR)

## Observed data: 100 replicates of a univariate random variable
Z <- matrix(rnorm(100), nrow = 1)

## Construct an (un-trained) point estimator
estimator <- initialise_estimator(1, architecture = "MLP")

## Apply the estimator
estimate(estimator, Z)
}
}
