% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NeuralNetTools_utils.R
\name{layer_lines}
\alias{layer_lines}
\title{Plot connection weights}
\usage{
layer_lines(mod_in, h_layer, layer1 = 1, layer2 = 2, out_layer = FALSE,
  nid, rel_rsc, all_in, pos_col, neg_col, x_range, y_range, line_stag, x_names,
  layer_x, struct, max_sp, prune_col = NULL, prune_lty = "dashed", skip)
}
\arguments{
\item{mod_in}{neural network model object}

\item{h_layer}{numeric indicating which connections to plot for the layer}

\item{layer1}{numeric indicating order of first layer (for multiple hiden layers)}

\item{layer2}{numeric indicating order of second layer (for multiple hiden layers)}

\item{out_layer}{logical indicating if the lines are for the output layer}

\item{nid}{logical value indicating if neural interpretation diagram is plotted, default \code{TRUE}}

\item{rel_rsc}{numeric indicating the scaling range for the width of connection weights in a neural interpretation diagram. Default is \code{NULL} for no rescaling.}

\item{all_in}{chr string indicating names of input variables for which connections are plotted, default all}

\item{pos_col}{chr string indicating color of positive connection weights, default \code{'black'}}

\item{neg_col}{chr string indicating color of negative connection weights, default \code{'grey'}}

\item{x_range}{numeric of x axis range for base plot}

\item{y_range}{numeric of y axis range for base plot}

\item{line_stag}{numeric value that specifies distance of connection weights from nodes}

\item{x_names}{chr string for names of input variables}

\item{layer_x}{numeric indicating locations of layers on x axis}

\item{struct}{numeric vector for network structure}

\item{max_sp}{logical indicating if space is maximized in plot}

\item{prune_col}{chr string indicating color of pruned connections, otherwise not shown}

\item{prune_lty}{line type for pruned connections, passed to \code{\link[graphics]{segments}}}

\item{skip}{logical to plot connections for skip layer}
}
\description{
Plot connection weights in \code{\link{plotnet}}
}

