% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneAgeTest.R
\docType{methods}
\name{plot-methods}
\alias{plot-methods}
\alias{plot,oneAgeTest-method}
\alias{plot.oneAgeTest}
\alias{plot,ageTests-method}
\alias{plot.ageTests}
\title{Method \code{"plot"} for Classes \code{"\linkS4class{oneAgeTest}"} and \code{"\linkS4class{ageTests}"}}
\usage{
\S4method{plot}{oneAgeTest}(x, y = NULL, main = "", col = "red")
}
\arguments{
\item{x}{an object of class "oneAgeTest" or "ageTests" (see section Methods)}

\item{y}{NUll}

\item{main}{a character string, title of the plot}

\item{col}{a character string, color of the common age(s) density(ies)}
}
\description{
Display densities of the ages calculated by the function
\code{\link{calculateAges}()}, as well as the common age(s) density(ies) as 
returned by the function \code{\link{tests}()}.
}
\details{
The estimated densities are Gaussian, as supposed by the model 
described in Montel \emph{et al.} (1996). Each density is referenced by its 
number to help identify outliers or invalid measurements.

Also note that if an object of class \code{\linkS4class{oneAgeTest}} is passed
to the function, the common age(s) densities is displayed even if the test of
the function \code{\link{tests}()} is rejected.

If argument \option{col} is supplied, it is used to display 
the density(ies) of the common age(s).
}
\section{Usage}{
 plot(x, ...)
}

\section{Methods}{

\itemize{
   \item \code{signature(object = "oneAgeTest")}: an object of type
         \code{\linkS4class{oneAgeTest}} as produced by the function
         \code{\link{tests}()}.
   \item \code{...}: further arguments passed to the function \code{\link{plot}()}.
}

\itemize{
   \item \code{signature(object = "ageTests")}: an object of type
         \code{\linkS4class{ageTests}} as produced by the function
         \code{\link{tests}()}.
   \item \code{...}: further arguments passed to the function \code{\link{plot}()}.
}
}

\examples{
data(srilanka)
calculated.ages <- calculateAges(srilanka, nloops = 10)
res.tests <- tests(calculated.ages, 1, 3)
plot(res.tests, main = "Densities", col = "lightseagreen")

}
\references{
Montel J.M., Foret S., Veschambre M., Nicollet C., Provost A. (1996) Electron
microprobe dating of monazite. \emph{Chemical Geology}, \bold{131}, 37--53.
}
\seealso{
\code{\link{tests}()}, \code{\linkS4class{oneAgeTest}}, \code{\linkS4class{ageTests}}
}
\author{
Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}
}
\keyword{methods}
