% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AENN.R
\name{AENN}
\alias{AENN}
\alias{AENN.default}
\alias{AENN.formula}
\title{All-k Edited Nearest Neighbors}
\usage{
\method{AENN}{formula}(formula, data, ...)

\method{AENN}{default}(x, k = 5, classColumn = ncol(x), ...)
}
\arguments{
\item{formula}{A formula describing the classification variable and the attributes to be used.}

\item{data, x}{Data frame containing the tranining dataset to be filtered.}

\item{...}{Optional parameters to be passed to other methods.}

\item{k}{Total number of nearest neighbors to be used.}

\item{classColumn}{Positive integer indicating the column which contains the
(factor of) classes. By default, the last column is considered.}
}
\value{
An object of class \code{filter}, which is a list with seven components:
\itemize{
   \item \code{cleanData} is a data frame containing the filtered dataset.
   \item \code{remIdx} is a vector of integers indicating the indexes for
   removed instances (i.e. their row number with respect to the original data frame).
   \item \code{repIdx} is a vector of integers indicating the indexes for
   repaired/relabelled instances (i.e. their row number with respect to the original data frame).
   \item \code{repLab} contains the new labels for repaired instances.
   \item \code{parameters} is a list containing the argument values.
   \item \code{call} contains the original call to the filter.
   \item \code{extraInf} is a character that includes additional interesting
   information not covered by previous items.
}
}
\description{
Similarity-based filter for removing label noise from a dataset as a
preprocessing step of classification. For more information, see 'Details' and
'References' sections.
}
\details{
\code{AENN} applies the Edited Nearest Neighbor algorithm \code{\link{ENN}} for all integers between 1 and \code{k}
on the whole dataset. At the end, any instance considered noisy by some \emph{ENN} is removed.
}
\examples{
# Next example is not run in order to save time
\dontrun{
data(iris)
out <- AENN(Species~.-Petal.Length,iris)
print(out)
identical(out$cleanData, iris[setdiff(1:nrow(iris),out$remIdx),])
}
}
\references{
Tomek I. (1976, June): An Experiment with the Edited Nearest-Neighbor Rule, in
\emph{Systems, Man and Cybernetics, IEEE Transactions on}, vol.SMC-6, no.6, pp. 448-452.
}

