% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip_ocs.R
\name{zip_ocs}
\alias{zip_ocs}
\title{Download Case Study Repository Zip File}
\usage{
zip_ocs(casestudy, outpath = NULL)
}
\arguments{
\item{casestudy}{character string, name of the case study to download zip file from.
The input name should follow the same naming scheme as the repository on GitHub:

ocs-bp-rural-and-urban-obesity

ocs-bp-air-pollution

ocs-bp-vaping-case-study

ocs-bp-opioid-rural-urban

ocs-bp-RTC-wrangling

ocs-bp-RTC-analysis

ocs-bp-youth-disconnection

ocs-bp-youth-mental-health

ocs-bp-school-shootings-dashboard

ocs-bp-co2-emissions

ocs-bp-diet}

\item{outpath}{character string, path to the directory where the downloaded
data folder should be saved.}
}
\value{
If download is successful, the path to the downloaded data folder is
returned. Otherwise the appropriate error message is returned.
}
\description{
Download the specified case study repository zip file and unzip it to a local directory.
}
\details{
This function downloads the specified OCS case study repository
from GitHub as a zip file. The function unzips the folder and saves it as
a new R project in a local directory. This makes it so the case study
repository, including all of the code, data, and document files, are downloaded
with a single function. Wrapper for the use_zip function from usethis.
}
\examples{
tmp = tempfile()
dir.create(tmp)
zip_ocs('ocs-bp-co2-emissions', outpath = tmp)

}
