% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KowaAP7000Client.r
\name{opiPresent_for_KowaAP7000}
\alias{opiPresent_for_KowaAP7000}
\title{Implementation of opiPresent for the KowaAP7000 machine.}
\arguments{
\item{stim}{Stimulus to present (a list, see \code{kowa.*} for details).}

\item{nextStim}{The stimulus to present after stim
(it is not presented, but projector can move to it during response window)}
}
\value{
See \link{kowa.presentStatic}, \link{kowa.presentTemporal}, or \link{kowa.presentKinetic}.
}
\description{
This is for internal use only. Use \code{\link[=opiPresent]{opiPresent()}} with the same arguments and
the class of \code{stim} as one of \code{opiStaticStimulus}, \code{opiTemporalStimulus}, or \code{opiKineticStimulus}.
}
\examples{
\dontrun{
  chooseOpi("KowaAP7000")
  if (!is.null(opiInitialize()$err))
      stop("opiInitialize failed")
  s <- list(x=9, y=9, level=dbTocd(db), size=0.43, color="white",
            duration=200, responseWindow=1500, checkFixationOK=NULL)
  class(s) <- "opiStaticStimulus"
  print(opiPresent(s, NULL))
}

}
\seealso{
\link{kowa.presentStatic}, \link{kowa.presentTemporal}, \link{kowa.presentKinetic}
}
