% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Pxx}
\alias{Pxx}
\title{A function to compute the mean proximity between members of a group (Pxx)}
\usage{
Pxx(x, d = NULL, fdist = 'e', distin = 'm',  distout = 'm', diagval = '0', 
spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}

\item{d}{- a matrix of the distances between spatial unit centroids}

\item{fdist}{- the method used for distance interaction matrix: 
e' for inverse exponential function (by default) and 'l' for linear.}

\item{distin}{- input metric conversion, based on  \pkg{bink} package and 
includes conversions from 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{distout}{- output metric conversion, based on  \pkg{bink} package and 
includes conversions to 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{diagval}{- when providing a spatial object or a shape file, 
the user has the choice of the spatial matrix diagonal definition: 
diagval = '0' (by default) for an null diagonal and diagval = 'a' 
to compute the diagonal as 0.6 * square root (spatial units area) (White, 1983)}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) containing 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}
}
\value{
a numeric vector containing Pxx index value for 
each population group
}
\description{
Mean proximity, Pxx, computes the mean distance 
between the members of a group. The distance matrix can be expressed as  
a linear or as an inverse exponential function of the distance between 
spatial units centroids.The function can be used in two ways: to providea 
a distance matrix  or a external geographic information source (spatial 
object or shape file).
}
\examples{
x <- segdata@data[ ,1:2]
ar<-area(segdata)
dist <- distance(segdata)
diag(dist)<-sqrt(ar) * 0.6
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'

Pxx(x, spatobj = segdata)

Pxx(x, folder = foldername, shape = shapename, fdist = 'l') 

Pxx(x, spatobj = segdata, diagval ='a')

Pxx(x, d = dist, fdist = 'e')

}
\references{
White M. J. (1983) \emph{The Measurement of Spatial 
Segregation}. American Journal of Sociology, 88, p. 1008-1019
}
\seealso{
Proximity measures: 
\code{\link{Pxy}}, \code{\link{Poo}}, \code{\link{SP}}

Clustering Indices: 
\code{\link{ACL}}, \code{\link{RCL}}
}

