---
title: "Dimensions of social segregation"
author: "Mihai Tivadar"
date: "2017-08-30"
output: rmarkdown::html_vignette
vignette: >
  %\VignetteIndexEntry{Vignette Title}
  %\VignetteEngine{knitr::rmarkdown}
  %\VignetteEncoding{UTF-8}
---

## Dimensions of social segregation



Spatial segregation is defined as inequality in the spatial distribution of
social groups in a residential area. It can be measured in relation 
to various dimensions such as evenness, exposure, concentration, clustering
and centralization (Massey & Denton, 1988). There is a distinction between
different types of segregation indices:

- onegroup indices: measure the segregation of a group compared to all
population
- intergroups indices: compare the distribution of a social group with another
group
- multigroups indices: evaluate a global segregation level 
- local indices: measure the segregation intensity variation in space


## Eveness

Eveness refers to the differential distribution of social groups among spatial
units in the residential area. 


## Exposure

Exposure refers to the potential interaction between members of the same group 
(intragroup indices) or of different groups (intergroup indices)

## Concentration

Concentration refers to the physical space occupied by social groups in the
area.

## Clustering

Clustering refers to the degree to which a group members live disproportionately in
contiguous areas

## Centralisation

Centranlisation refers to the degree to which a group is located near the center 
of an residential area

Reference: 
Massey D. S. and Denton N. A. (1988) ' The dimensions of residential segregation'. Social Forces 67(2), pp. 281-315.
