% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{xPy}
\alias{xPy}
\title{A function to compute interaction index (xPy)}
\usage{
xPy(x, exact = FALSE)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}

\item{exact}{- a logical variable to specifiy the index version: 
exact = FALSE (by default) for the approximate version of the index, 
and exact = TRUE for the exact version}
}
\value{
a matrix with interaction index values
}
\description{
The interaction index, xPy, is an exposure 
between groups index which measures the probability that a member 
of a group shares the same spatial unit with a member of another 
group. The index can be calculated with the approximate or exact 
method (see Bell, 1954).
}
\examples{
x <- segdata@data[ ,1:2]
xPy(x) 
}
\references{
Bell W. (1954) \emph{A probability model for the 
measurement of ecological segregation}. Social Forces 32(4),
 pp. 357-364
}
\seealso{
Isolation indices: 
\code{\link{xPx}}, \code{\link{Eta2}},  \code{\link{DPxx}}

Distance decay interaction index: \code{\link{DPxy}}
}
