% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{segdataclean}
\alias{segdataclean}
\title{A function to clean and prepare the data for segregation analysis}
\usage{
segdataclean (x, c = NULL, b = NULL, a = NULL, p = NULL, 
ck = NULL, d = NULL, dc = NULL, spatobj = NULL, folder = NULL, shape = NULL, 
warnings = T)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}

\item{c}{- a standard binary contiguity (adjacency) symmetric matrix where 
each element \emph{Cij} equals 1 if \emph{i}-th and \emph{j}-th spatial 
units are adjacent, and 0 otherwise.}

\item{b}{- a common boundaries matrix where each element \emph{Bij}}

\item{a}{- a numeric vector containing spatial unit areas}

\item{p}{- a numeric vector containing spatial units perimeters.}

\item{ck}{- a list containing contiguity matrices coresponding to each order 
(from 1 to K)}

\item{d}{- a matrix of the distances between spatial unit centroids}

\item{dc}{- a numeric vector containing the distances between spatial units
centroids and the central spatial unit}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) with 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile is located on the drive}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension).}

\item{warnings}{- warning alert (by default TRUE)}
}
\value{
The objects (data matrix, geographical vectors/matrices, spatial objects)
cleaned from null rows or columns
}
\description{
The function cleans and prepares the data for segregation analysis
}
\examples{
x <- segdata@data[ ,1:2]
x[ ,3] <- rep (0 ,100)
x[1:3, ] <- rep (c(0, 0, 0), 3)
x1 <- x
spatobj <- segdata
cldata <- segdataclean(x1, segdata)
x1 <- cldata$x
spatobj <- cldata$spatobj

c <- contig (segdata)
c <- segdataclean(x, c = c)$c

}
\seealso{
Other local indices: \code{\link{LQ}}, 
\code{\link{HLoc}}, \code{\link{LShannon}}
}
