/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.generator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.andwellness.xml.datagenerator.generator.JSONGeneratorType;
import org.andwellness.xml.datagenerator.model.ChoiceCustom;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.model.RepeatableSet;
import org.andwellness.xml.datagenerator.model.Response;
import org.andwellness.xml.datagenerator.model.Survey;
import org.andwellness.xml.datagenerator.utility.JSONUtility;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.apache.log4j.Logger;
import org.json.JSONArray;

public class UploadJSONGeneratorType
extends JSONGeneratorType {
    private static Logger _logger = Logger.getLogger(UploadJSONGeneratorType.class);
    private String[] _locationStatuses = new String[]{"valid", "unavailable", "inaccurate", "stale"};

    @Override
    public Object translateSurveysToJson(List<Survey> surveyList) {
        JSONArray finalJSONArray = new JSONArray();
        for (Survey survey : surveyList) {
            JSONArray surveyJSONArray = this.translateSurveyToJsonArray(survey);
            JSONUtility.appendJSONArray(finalJSONArray, surveyJSONArray);
        }
        return finalJSONArray;
    }

    @Override
    public JSONArray translateSurveyToJsonArray(Survey survey) {
        JSONArray translatedJSONArray = new JSONArray();
        HashMap<String, Object> generatedSurveyJSON = new HashMap<String, Object>();
        HashMap<String, Object> locationDataJSON = new HashMap<String, Object>();
        HashMap<String, Object> surveyLaunchContextJSON = new HashMap<String, Object>();
        JSONArray surveyResponsesJSONArray = new JSONArray();
        generatedSurveyJSON.put("time", survey.getCreationTime().getTime());
        generatedSurveyJSON.put("timezone", survey.getTz());
        generatedSurveyJSON.put("survey_key", UUID.randomUUID());
        String locationStatus = this._locationStatuses[ValueCreator.randomPositiveIntModulus(3)];
        generatedSurveyJSON.put("location_status", locationStatus);
        if (!"unavailable".equals(locationStatus)) {
            locationDataJSON.put("latitude", survey.getLat());
            locationDataJSON.put("longitude", survey.getLon());
            locationDataJSON.put("accuracy", Float.valueOf(ValueCreator.randomPositiveFloat()));
            locationDataJSON.put("provider", ValueCreator.randomProvider());
            locationDataJSON.put("time", survey.getCreationTime().getTime());
            locationDataJSON.put("timezone", survey.getTz());
            generatedSurveyJSON.put("location", locationDataJSON);
        }
        generatedSurveyJSON.put("survey_id", survey.getId());
        surveyLaunchContextJSON.put("launch_time", survey.getCreationTime().getTime());
        surveyLaunchContextJSON.put("launch_timezone", survey.getTz());
        surveyLaunchContextJSON.put("active_triggers", new JSONArray());
        generatedSurveyJSON.put("survey_launch_context", surveyLaunchContextJSON);
        List<Response> responseList = survey.getResponseList();
        for (Response response : responseList) {
            if (response instanceof DataPoint) {
                DataPoint dataPoint = (DataPoint)response;
                try {
                    Map<String, Object> translatedDataPointJSON = this.translateDataPoint(dataPoint);
                    surveyResponsesJSONArray.put(translatedDataPointJSON);
                }
                catch (IllegalArgumentException e) {
                    _logger.warn(e.getMessage());
                }
                continue;
            }
            if (!(response instanceof RepeatableSet)) continue;
            RepeatableSet repeatableSet = (RepeatableSet)response;
            Map<String, Object> repeatableSetJSON = this.translateRepeatableSet(repeatableSet);
            surveyResponsesJSONArray.put(repeatableSetJSON);
        }
        generatedSurveyJSON.put("responses", surveyResponsesJSONArray);
        translatedJSONArray.put(generatedSurveyJSON);
        return translatedJSONArray;
    }

    private Map<String, Object> translateDataPoint(DataPoint dataPoint) {
        Map<String, Object> translatedDataPoint;
        if (dataPoint.isNotDisplayed()) {
            Map<String, Object> translatedDataPoint2 = this.translateNotDisplayed(dataPoint);
            return translatedDataPoint2;
        }
        if (dataPoint.isSkipped()) {
            Map<String, Object> translatedDataPoint3 = this.translateSkipped(dataPoint);
            return translatedDataPoint3;
        }
        switch (dataPoint.getPromptType()) {
            case timestamp: {
                translatedDataPoint = this.translateTimestamp(dataPoint);
                break;
            }
            case number: {
                translatedDataPoint = this.translateNumber(dataPoint);
                break;
            }
            case hours_before_now: {
                translatedDataPoint = this.translateHoursBeforeNow(dataPoint);
                break;
            }
            case text: {
                translatedDataPoint = this.translateText(dataPoint);
                break;
            }
            case multi_choice: {
                translatedDataPoint = this.translateMultiChoice(dataPoint);
                break;
            }
            case single_choice: {
                translatedDataPoint = this.translateSingleChoice(dataPoint);
                break;
            }
            case single_choice_custom: {
                translatedDataPoint = this.translateSingleChoiceCustom(dataPoint);
                break;
            }
            case multi_choice_custom: {
                translatedDataPoint = this.translateMultiChoiceCustom(dataPoint);
                break;
            }
            case photo: {
                translatedDataPoint = this.translatePhoto(dataPoint);
                break;
            }
            case remote_activity: {
                translatedDataPoint = this.translateRemoteActivity(dataPoint);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown prompt type " + (Object)((Object)dataPoint.getPromptType()));
            }
        }
        return translatedDataPoint;
    }

    private Map<String, Object> translateRepeatableSet(RepeatableSet repeatableSet) {
        HashMap<String, Object> repeatableSetJSON = new HashMap<String, Object>();
        repeatableSetJSON.put("repeatable_set_id", repeatableSet.getId());
        repeatableSetJSON.put("skipped", "false");
        repeatableSetJSON.put("not_displayed", new Boolean(repeatableSet.getNotDisplayed()).toString());
        JSONArray repeatableSetResponsesArray = new JSONArray();
        Iterator<List<DataPoint>> repeatableSetIterator = repeatableSet.getRepeatableSetListIterator();
        while (repeatableSetIterator.hasNext()) {
            List<DataPoint> repeatableSetResponseList = repeatableSetIterator.next();
            JSONArray individualSetArray = new JSONArray();
            for (DataPoint repeatableSetResponse : repeatableSetResponseList) {
                try {
                    Map<String, Object> translatedDataPointJSON = this.translateDataPoint(repeatableSetResponse);
                    individualSetArray.put(translatedDataPointJSON);
                }
                catch (IllegalArgumentException e) {
                    _logger.warn(e.getMessage());
                }
            }
            repeatableSetResponsesArray.put(individualSetArray);
        }
        repeatableSetJSON.put("responses", repeatableSetResponsesArray);
        return repeatableSetJSON;
    }

    private Map<String, Object> translateTimestamp(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", dataPoint.getValue());
        return translatedDataPoint;
    }

    private Map<String, Object> translateNumber(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", (Long)dataPoint.getValue());
        return translatedDataPoint;
    }

    private Map<String, Object> translateHoursBeforeNow(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", (Integer)dataPoint.getValue());
        return translatedDataPoint;
    }

    private Map<String, Object> translateText(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", dataPoint.getValue());
        return translatedDataPoint;
    }

    private Map<String, Object> translateMultiChoice(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        List dataPointValue = (List)dataPoint.getValue();
        JSONArray valueJsonArray = new JSONArray();
        for (Integer choice : dataPointValue) {
            valueJsonArray.put(choice);
        }
        translatedDataPoint.put("value", valueJsonArray);
        return translatedDataPoint;
    }

    private Map<String, Object> translateSingleChoice(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", (Integer)dataPoint.getValue());
        return translatedDataPoint;
    }

    private Map<String, Object> translateSingleChoiceCustom(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        ChoiceCustom choiceCustomModel = (ChoiceCustom)dataPoint.getValue();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", choiceCustomModel.getSelectedChoices().get(0));
        return translatedDataPoint;
    }

    private Map<String, Object> translateMultiChoiceCustom(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        ChoiceCustom choiceCustomModel = (ChoiceCustom)dataPoint.getValue();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        JSONArray selectedChoicesJsonArray = new JSONArray();
        Iterator<String> selectedChoicesIterator = choiceCustomModel.getSelectedChoices().iterator();
        while (selectedChoicesIterator.hasNext()) {
            selectedChoicesJsonArray.put(selectedChoicesIterator.next());
        }
        translatedDataPoint.put("value", selectedChoicesJsonArray);
        return translatedDataPoint;
    }

    private Map<String, Object> translatePhoto(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", dataPoint.getValue());
        return translatedDataPoint;
    }

    private Map<String, Object> translateRemoteActivity(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", dataPoint.getValue());
        return translatedDataPoint;
    }

    private Map<String, Object> translateNotDisplayed(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", "NOT_DISPLAYED");
        return translatedDataPoint;
    }

    private Map<String, Object> translateSkipped(DataPoint dataPoint) {
        HashMap<String, Object> translatedDataPoint = new HashMap<String, Object>();
        translatedDataPoint.put("prompt_id", dataPoint.getId());
        translatedDataPoint.put("value", "SKIPPED");
        return translatedDataPoint;
    }
}

