% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_ordinalRegression.R
\name{olink_ordinalRegression_posthoc}
\alias{olink_ordinalRegression_posthoc}
\title{Function which performs an posthoc test per protein.}
\usage{
olink_ordinalRegression_posthoc(
  df,
  olinkid_list = NULL,
  variable,
  covariates = NULL,
  effect,
  verbose = T
)
}
\arguments{
\item{df}{NPX data frame in long format with at least protein name (Assay), OlinkID, UniProt, Panel and a factor with at least 3 levels.}

\item{olinkid_list}{Character vector of OlinkID's on which to perform post hoc analysis. If not specified, all assays in df are used.}

\item{variable}{Single character value or character array.
Variable(s) to test. If length > 1, the included variable names will be used in crossed analyses .
Also takes ':' notation.}

\item{covariates}{Single character value or character array. Default: NULL.
Covariates to include. Takes ':'/'*' notation. Crossed analysis will not be inferred from main effects.}

\item{effect}{Term on which to perform post-hoc. Character vector. Must be subset of or identical to variable.}

\item{verbose}{Boolean. Default: True. If information about removed samples, factor conversion and final model formula is to be printed to the console.}
}
\value{
Tibble of posthoc tests for specified effect, arranged by ascending adjusted p-values.
}
\description{
Performs a post hoc ANOVA test using emmeans::emmeans with Tukey p-value adjustment per assay (by OlinkID) for each panel at confidence level 0.95.
See \code{olink_anova} for details of input notation. \cr\cr
The function handles both factor and numerical variables and/or covariates.
The posthoc test for a numerical variable compares the difference in means of the outcome variable (default: NPX) for 1 standard deviation difference in the numerical variable, e.g.
mean NPX at mean(numerical variable) versus mean NPX at mean(numerical variable) + 1*SD(numerical variable).
}
\examples{
\donttest{
library(dplyr)
npx_df <- npx_data1 \%>\% filter(!grepl('control',SampleID, ignore.case = TRUE))
#Two-way Ordinal Regression.
#Results in model NPX~Treatment*Time.
ordinalRegression_results <- olink_ordinalRegression(df = npx_df,
                             variable="Treatment:Time")

#Posthoc test for the model NPX~Treatment*Time,
#on the interaction effect Treatment:Time.

#Filtering out significant and relevant results.
significant_assays <- ordinalRegression_results \%>\%
filter(Threshold == 'Significant' & term == 'Treatment:Time') \%>\%
select(OlinkID) \%>\%
distinct() \%>\%
pull()

#Posthoc
ordinalRegression_results_posthoc_results <- olink_ordinalRegression_posthoc(npx_df,
variable=c("Treatment:Time"),
covariates="Site",
olinkid_list = significant_assays,
effect = "Treatment:Time")}
}
