% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addMapping}
\alias{addMapping}
\title{Add mapping object}
\usage{
addMapping(study, mapping, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{mapping}{Feature IDs from models. The input object is a list of named
data frames. For each data frame, column names indicate model names while
rows indicate featureIDs per model. Features with same index position across
columns are treated as mapped across models. For each model, feature IDs must
match feature IDs available in the results object of the respective model.
1:N relationships are allowed.

Mapping list elements are required to be named as 'default' or after a model
name as provided in addModels(). If a single data frame is provided, this
list element is recommended to be named 'default'. For multiple list
elements, each with its own data frame, list elements should be named after
model name(s) (a single element may still be  named 'default'). In that case,
when navigating in ON front-end (FE), mapping element related to the selected
model in the FE will be used in multimodel plots. If a selected model in FE
does not have a corresponding mapping list element, it may still use the
mapping list element called 'default' if this is available.

E.g., if in a study there are models "transcriptomics" and "proteomics" and
the user wants to create a plot based on data from both, a mapping list
should be provided with addMapping(). In this case, the mapping list element
may be named 'default'. This should contain a data frame with column names
'transcriptomics' and 'proteomics', where feature IDs that map across models
are found in the same row.}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
  \code{study}, but modified to include the newly added data
}
\description{
Add mapping object
}
\seealso{
\code{\link{getPlottingData}}, \code{\link{plotStudy}}
}
