% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseMissingData.R
\name{summariseMissingData}
\alias{summariseMissingData}
\title{Summarise missing data in omop tables}
\usage{
summariseMissingData(
  cdm,
  omopTableName,
  col = NULL,
  sex = FALSE,
  year = lifecycle::deprecated(),
  interval = "overall",
  ageGroup = NULL,
  sample = 1e+06,
  dateRange = NULL
)
}
\arguments{
\item{cdm}{A cdm object}

\item{omopTableName}{A character vector of the names of the tables to
summarise in the cdm object.}

\item{col}{A character vector of column names to check for missing values.
If \code{NULL}, all columns in the specified tables are checked. Default is \code{NULL}.}

\item{sex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{year}{deprecated}

\item{interval}{Time interval to stratify by. It can either be "years", "quarters", "months" or "overall".}

\item{ageGroup}{A list of ageGroup vectors of length two. Code use will be
thus summarised by age groups.}

\item{sample}{An integer to sample the table to only that number of records.
If NULL no sample is done.}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}
}
\value{
A summarised_result object with results overall and, if specified, by
strata.
}
\description{
Summarise missing data in omop tables
}
\examples{
\donttest{
cdm <- mockOmopSketch(numberIndividuals = 100)

result <- summariseMissingData (cdm = cdm,
omopTableName = c("condition_occurrence", "visit_occurrence"))

PatientProfiles::mockDisconnect(cdm)
}
}
