% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_CI}
\alias{get_CI}
\title{Calculates the confidence interval.}
\usage{
get_CI(k, r1, n1, n, alpha = 0.05, precision = 4)
}
\arguments{
\item{k}{overall observed responses (must be larger than r1).}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{n}{overall sample size.}

\item{alpha}{determining the two sided 1-2*alpha confidence interval.}

\item{precision}{gives the precision (in decimal numbers) to which the confidence interval should be calculated (should be less than 10).}
}
\description{
Calculates the two sided 1-2*alpha confidence interval based on the work from Koyama and Chen.
}
\examples{
#Calculate a Simon's two-stage design
design <- getSolutions()$Solutions[3,] #minimax-design for the default values.

#Assume 9 responses were observed in the whole trial.
k = 9

ci <- get_CI(k, design$r1, design$n1, design$n)
}
\references{
Koyama T and Chen H (2008): Proper inference from Simon's two-stage designs. Statistics in Medicine, 27(16):3145-3154.
}

