% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{get_p_exact_subset}
\alias{get_p_exact_subset}
\title{Calculates the exact p value.}
\usage{
get_p_exact_subset(t, u, r1, n1, n, pc0, pt0, sub1 = setupSub1Design())
}
\arguments{
\item{t}{observed responses in the subset endpoint.}

\item{u}{observed responses in the superset endpoint.}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{n}{overall sample size.}

\item{pc0}{the response probability for the subset endpoint under the null hypothesis.}

\item{pt0}{the response probability for the superset endpoint under the null hypothesis.}

\item{sub1}{"sub1"-object used to calculate the p value in c++ .}
}
\description{
Calculates the exact p value for a given subset design.
}
\examples{
#Setup "sub1"-object
sub1 <- setupSub1Design(pc0 = 0.5, pt0 = 0.6)

#Calculate a  subset design
design <- getSolutionsSub1(sub1, skipN1 = FALSE)$Solutions[4,]

#Assuming 9 responses in the subset endpoint and 13 responses
#in the superset endpoint were observed.
t = 9
u = 13

p_val <- get_p_exact_subset(t, u, design$r1, design$n1, design$n, design$pc0, design$pt0, sub1)
p_val
}
\seealso{
\code{\link{setupSub1Design}}
}
