% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneR.R
\name{predict.OneR}
\alias{predict.OneR}
\title{Predict method for OneR models}
\usage{
\method{predict}{OneR}(object, newdata, ...)
}
\arguments{
\item{object}{object of class \code{"OneR"}.}

\item{newdata}{dataframe in which to look for the feature variable with which to predict.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Predict values based on OneR model object.
}
\details{
\code{newdata} can have the same format as used for building the model but must at least have the feature variable that is used in the OneR rules.
If cases appear that were not present when building the model the predicted value is \code{UNSEEN}.
}
\examples{
model <- OneR(iris)
prediction <- predict(model, iris[1:4])
eval_model(prediction, iris[5])
}
\author{
Holger von Jouanne-Diedrich
}
\references{
\url{http://vonjd.github.io/OneR/}
}
\seealso{
\code{\link{OneR}}
}

