% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameters.R
\name{Parameters}
\alias{Parameters}
\title{R6Class Parameters}
\description{
Wrapper class for the \code{parameters} C struct (\emph{params.h}).
}
\details{
For a detailed explanation of the available parameters (including sources
and references), please read the
\href{https://github.com/BDI-pathogens/OpenABM-Covid19/blob/master/documentation/parameters/parameter_dictionary.md}{Online Documentation}.
}
\seealso{
\code{\link{Model}}

the C params R pointer object
check the C params still exists
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{household_df}}{Household Data Frame.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{c_params}}{the C param sR pointer object (SWIG wrapped)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Parameters$new()}}
\item \href{#method-get_param}{\code{Parameters$get_param()}}
\item \href{#method-set_param}{\code{Parameters$set_param()}}
\item \href{#method-set_param_list}{\code{Parameters$set_param_list()}}
\item \href{#method-set_demographic_household_table}{\code{Parameters$set_demographic_household_table()}}
\item \href{#method-set_occupation_network_table}{\code{Parameters$set_occupation_network_table()}}
\item \href{#method-return_param_object}{\code{Parameters$return_param_object()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Parameters$new(
  input_param_file = NA_character_,
  param_line_number = 1,
  output_file_dir = "./",
  input_households = NA_character_,
  hospital_input_param_file = NA_character_,
  hospital_param_line_number = NA_integer_,
  read_param_file = TRUE,
  read_hospital_param_file = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_param_file}}{Input parameters CSV file path.
Optional, default:
\code{system.file("default_params", "baseline_parameters.csv", package = "OpenABMCovid19")}}

\item{\code{param_line_number}}{Which column of the input param file to read.}

\item{\code{output_file_dir}}{Where to write output files to.}

\item{\code{input_households}}{Household demographics file.
Optional, default:
\code{system.file("default_params", "baseline_household_demographics.csv", package = "OpenABMCovid19")}}

\item{\code{hospital_input_param_file}}{Hospital input parameters CSV file path.
Optional, default:
\code{system.file("default_params", "hospital_baseline_parameters.csv", package = "OpenABMCovid19")}}

\item{\code{hospital_param_line_number}}{Which column of the hospital input
param file to read.}

\item{\code{read_param_file}}{A boolean. If \code{TRUE}, read
\code{input_param_file}. If \code{FALSE}, ignore
\code{input_param_file}.}

\item{\code{read_hospital_param_file}}{A boolean. If \code{TRUE}, read
\code{hospital_input_param_file}. If \code{FALSE}, ignore
\code{hospital_input_param_file}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_param"></a>}}
\if{latex}{\out{\hypertarget{method-get_param}{}}}
\subsection{Method \code{get_param()}}{
Get a C parameter by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Parameters$get_param(param)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{A string representing the C parameter's name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_param"></a>}}
\if{latex}{\out{\hypertarget{method-set_param}{}}}
\subsection{Method \code{set_param()}}{
Set a C parameter by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Parameters$set_param(param, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{A string representing the C parameter's name}

\item{\code{value}}{The new value for the C parameter.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_param_list"></a>}}
\if{latex}{\out{\hypertarget{method-set_param_list}{}}}
\subsection{Method \code{set_param_list()}}{
Set C parameters from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Parameters$set_param_list(params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{A named list with the name being the parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_demographic_household_table"></a>}}
\if{latex}{\out{\hypertarget{method-set_demographic_household_table}{}}}
\subsection{Method \code{set_demographic_household_table()}}{
Set the \code{demographic_household_table} C struct (defined in
\emph{demographics.h}). This function initializes the
\code{self$c_params$demo_house} member.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Parameters$set_demographic_household_table(df_demo_house)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df_demo_house}}{A data-frame representation of the
\code{demographic_household_table} C struct. The data-frame must contain
column names \code{c("ID", "age_group", "house_no")} and the number of
rows must be equal to \code{self$c_params$n_total}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} on success, \code{FALSE} on error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_occupation_network_table"></a>}}
\if{latex}{\out{\hypertarget{method-set_occupation_network_table}{}}}
\subsection{Method \code{set_occupation_network_table()}}{
Set the \code{demographic_occupation_network_table} C struct (defined in
\emph{demographics.h}). This function initializes the
\code{self$c_params$occupation_network_table} member.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Parameters$set_occupation_network_table(
  df_occupation_networks,
  df_occupation_network_properties
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df_occupation_networks}}{TODO(olegat)}

\item{\code{df_occupation_network_properties}}{TODO(olegat)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-return_param_object"></a>}}
\if{latex}{\out{\hypertarget{method-return_param_object}{}}}
\subsection{Method \code{return_param_object()}}{
Run a check on the parameters and return if the C code doesn't bail.
This function locks the parameter value (i.e. make this class
read-only))
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Parameters$return_param_object()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{self$c_params}
}
}
}
