% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listOMLTasks.R
\name{listOMLTasks}
\alias{listOMLTasks}
\title{List the first 5000 OpenML tasks.}
\usage{
listOMLTasks(task.type = NULL, estimation.procedure = NULL,
  evaluation.measures = NULL, number.of.instances = NULL,
  number.of.features = NULL, number.of.classes = NULL,
  number.of.missing.values = NULL, tag = NULL, data.name = NULL,
  data.tag = NULL, limit = 5000, offset = NULL, status = "active",
  verbosity = NULL)
}
\arguments{
\item{task.type}{[\code{character(1)}]\cr
If not \code{NULL}, only tasks belonging to the given task type are listed.
Use \code{listOMLTaskTypes()$name} to see possible values for \code{task.type}.
The default is \code{NULL}, which means that tasks with all available task types are listed.}

\item{estimation.procedure}{[\code{character}]\cr
If not \code{NULL}, only tasks belonging the given estimation procedures are listed.
Use \code{listOMLEstimationProcedures()$name} to see possible values for
\code{estimation.procedure}. The default is \code{NULL}, which means that tasks with all
available estimation procedures are listed.}

\item{evaluation.measures}{[\code{character}]\cr
If not \code{NULL}, only tasks belonging the given evaluation measures are listed.
Use \code{listOMLEvaluationMeasures()$name} to see possible values for
\code{evaluation.measures}. The default is \code{NULL}, which means that tasks with all
available evaluation measures are listed.}

\item{number.of.instances}{[\code{numeric(1) | numeric(2)}]\cr
If not \code{NULL}, subsets the entries with respect to the given values or,
if a vector of length 2 is passed, the given ranges.}

\item{number.of.features}{[\code{numeric(1) | numeric(2)}]\cr
If not \code{NULL}, it subsets the entries with respect to the given values or,
if a vector of length 2 is passed, the given range.}

\item{number.of.classes}{[\code{numeric(1) | numeric(2)}]\cr
If not \code{NULL}, subsets the entries with respect to the given values or,
if a vector of length 2 is passed, the given ranges.}

\item{number.of.missing.values}{[\code{numeric(1) | numeric(2)}]\cr
If not \code{NULL}, subsets the entries with respect to the given values or,
if a vector of length 2 is passed, the given ranges.}

\item{tag}{[\code{character}]\cr
If not \code{NULL} only entries with the corresponding \code{tag}s
are listed.}

\item{data.name}{[\code{character(1)}]\cr
Name of the data set.}

\item{data.tag}{[\code{character(1)}]\cr
Refers to the tag of the dataset the task is based on.
If not \code{NULL} only tasks with the corresponding \code{data.tag} are listed.}

\item{limit}{[\code{numeric(1)}]\cr
Optional. The maximum number of entries to return. 
Without specifying \code{offset}, it returns the first '\code{limit}' entries.
Setting \code{limit = NULL} returns all available entries.}

\item{offset}{[\code{numeric(1)}]\cr
Optional. The offset to start from. 
Should be indices starting from 0, which do not refer to IDs. 
Is ignored when no \code{limit} is given.}

\item{status}{[\code{character}]\cr
Subsets the results according to the status. Possible values are 
\code{{"active", "deactivated", "in_preparation", "all"}}.
Default is \code{"active"}.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{data.frame}].
}
\description{
The returned \code{data.frame} contains the \code{task_id}, the data set id \code{data.id},
the \code{status} and some describing data qualities.
Note that by default only the first 5000 data sets will be returned (due to the argument \dQuote{limit = 5000}).
}
\note{
This function is memoised. I.e., if you call this function twice in a running R session,
the first call will query the server and store the results in memory while the second and all subsequent calls will return
the cached results from the first call.
You can reset the cache by calling \code{\link[memoise]{forget}} on the function manually.
}
\examples{
# \dontrun{
# 	tasks = listOMLTasks()
# 	head(tasks)
# }
}
\seealso{
Other listing functions: \code{\link{chunkOMLlist}},
  \code{\link{listOMLDataSetQualities}},
  \code{\link{listOMLDataSets}},
  \code{\link{listOMLEstimationProcedures}},
  \code{\link{listOMLEvaluationMeasures}},
  \code{\link{listOMLFlows}}, \code{\link{listOMLRuns}},
  \code{\link{listOMLSetup}}, \code{\link{listOMLStudies}},
  \code{\link{listOMLTaskTypes}}

Other task-related functions: \code{\link{convertOMLTaskToMlr}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLTask}},
  \code{\link{listOMLTaskTypes}},
  \code{\link{makeOMLTask}}, \code{\link{tagOMLObject}}
}
\concept{listing functions}
\concept{task-related functions}
