% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxDataWLS.R
\name{omxAugmentDataWithWLSSummary}
\alias{omxAugmentDataWithWLSSummary}
\title{Estimate summary statistics used by the WLS fit function}
\usage{
omxAugmentDataWithWLSSummary(mxd, type = c("WLS", "DWLS", "ULS"),
  allContinuousMethod = c("cumulants", "marginals"), ...,
  exogenous = c(), fullWeight = TRUE, returnModel = FALSE,
  silent = TRUE)
}
\arguments{
\item{mxd}{an MxData object containing raw data}

\item{type}{the type of WLS weight matrix}

\item{allContinuousMethod}{which method to use when all indicators are continuous}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{exogenous}{names variables to be modelled as exogenous}

\item{fullWeight}{whether to produce a fullWeight matrix}

\item{returnModel}{whether to return the whole mxModel (TRUE) or just the mxData (FALSE)}

\item{silent}{logical. Whether to print status to terminal.}
}
\description{
The summary statistics are returned in the observedStats slot of
the MxData object.
}
\examples{
omxAugmentDataWithWLSSummary(mxData(Bollen[,1:8], 'raw'))
}
\seealso{
\link{mxFitFunctionWLS}
}
