% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repgrid-basicops.r
\name{[<-,repgrid-method}
\alias{[<-,repgrid-method}
\title{Method for "<-" assignment of the repgrid ratings.}
\usage{
\S4method{[}{repgrid}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{i, j}{Row and column indices.}

\item{...}{Not evaluated.}

\item{value}{Numeric replacement value(s).}
}
\description{
It should be possible to use it for ratings on all layers.
}
\examples{
\dontrun{
x <- randomGrid()
x[1,1] <- 2
x[1, ] <- 4
x[ ,2] <- 3
   
# settings values outside defined rating scale 
# range throws an error
x[1,1] <- 999
   
# removing scale range allows arbitary values to be set
x <- setScale(x, min = NA, max=NA) 
x[1,1] <- 999
}

}
