% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.r
\name{indexSelfConstruction}
\alias{indexSelfConstruction}
\title{Self construction profile}
\usage{
indexSelfConstruction(
  x,
  self,
  ideal,
  others = c(-self, -ideal),
  method = "euclidean",
  p = 2,
  normalize = TRUE,
  round = FALSE
)
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{self}{Numeric. Index of self element.}

\item{ideal}{Numeric. Index of ideal element.}

\item{others}{Numeric. Index(es) of self related "other" elements (e.g. father, friend).}

\item{method}{The distance or correlation measure:
\itemize{
\item Distances:  \code{euclidean}, \code{manhattan}, \code{maximum},  \code{canberra}, \code{binary}, \code{minkowski}
\item Correlations: \code{pearson}, \code{kendall}, \code{spearman}
}}

\item{p}{The power of the Minkowski distance, in case \code{minkowski} is used as argument for \code{method}, otherwise it is
ignored.}

\item{normalize}{Normalize values?}

\item{round}{Round average rating scores for 'others' to closest integer?}
}
\value{
List object of class \code{indexSelfConstruction}, containing the results from the calculations:
\itemize{
\item \code{grid}: Reduced grid with self, ideal and others
\item \code{method_type}: method type (correlation or distance)
\item \code{method}: correlation or distance method used
\item \code{self_element}: name of the self element
\item \code{ideal_element}: name of the ideal element
\item \code{other_elements}: name(s) of other elements
\item \code{self_ideal}: measure between self and ideal
\item \code{self_others}: measure between self and others
\item \code{ideal_others}: measure betwen ideal and others
}
}
\description{
TBD
}
\examples{
# using distance measures
indexSelfConstruction(boeker, 1, 2, c(3:11), method = "euclidean")
indexSelfConstruction(boeker, 1, 2, c(3:11), method = "manhattan")
indexSelfConstruction(boeker, 1, 2, c(3:11), method = "minkowski", p = 3)

# using correlation measures
indexSelfConstruction(boeker, 1, 2, c(3:11), method = "pearson")
indexSelfConstruction(boeker, 1, 2, c(3:11), method = "spearman")

# using not-normalized distances
indexSelfConstruction(boeker, 1, 2, c(3:11), method = "euclidean", normalize = FALSE)

# printing the results (biplot only works with)
cp <- indexSelfConstruction(boeker, 1, 2, c(3:11))
cp$grid  # grid with self, ideal and others
biplot2d(cp$grid, center = 4)  # midopoint centering
}
\references{
TBD
}
