% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimGLM.R
\name{Optim.GLM}
\alias{Optim.GLM}
\title{Find out what is the error distribution and link function that best fits a classification generalized linear model to your data}
\usage{
Optim.GLM(formula, data, p, criteria = c("success_rate", "error_ti",
  "error_tii"), seed = NULL, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x1 + x2 + \dots}}

\item{data}{Data frame from which variables specified in  \code{formula} are preferentially to be taken.}

\item{p}{A percentage of training elements}

\item{criteria}{This variable selects the criteria to select the best threshold. The default value is \code{success_rate}}

\item{seed}{a single value, interpreted as an integer, or \code{NULL}. The default value is \code{NULL}, but for future checks of the model or models generated it is advisable to set a random seed to be able to reproduce it.}

\item{...}{arguments passed to \code{\link[stats]{glm}}}
}
\value{
An object of class \code{Optim}. See\code{\link{Optim.object}}
}
\description{
\code{Optim.GLM} is used to fit the best classification \code{GLM} to a dataset. For this purpose, we examine the variation of the precision using the root mean square error (RMSE) when different error distribution and link function was used in the model. In addition, several thresholds are applied to check which is the most optimal cut for the indicators derived from the confusion matrix (success rate, error type I and error type II) according to a given criterion.
}
\examples{
if(interactive()){
## Load a Dataset
data(AustralianCredit)

## Create the model
creditscoring <- Optim.GLM(Y~., AustralianCredit, p = 0.7, seed=2018)

#See a ranking of the models tested
print(creditscoring)

#Access to summary of the best model
summary(creditscoring)

#not sure of like the best model, you can access to the all model, for example the 2nd model
summary(creditscoring,2)
}


}
