\name{wilcoxE.test}
\alias{wilcoxE.test}

\title{Wilcox Exact Test}
\description{
Performs exact one sample and two sample Wilcoxon tests on 
vectors of data.
}
\usage{
wilcoxE.test(x, y = NULL, mu = 0, paired = FALSE,
alternative = "two.sided", conf.level = 0.95)
}

\arguments{
  \item{x}{is a numeric vector of data values.  Non-finite 
  (i.e. infinite or missing) values will be omitted.}
  \item{y}{an optional numeric vector of data values}
  \item{mu}{a number specifying an optional parameter used to form the
          null hypothesis}
  \item{paired}{a logical indicating whether you want a paired test}
  \item{alternative}{ a character string specifying the alternative hypothesis,
          must be one of \code{"two.sided"} (default), \code{"greater"}, 
          or \code{"less"}.  The initial letter only may be given.}
  \item{conf.level}{confidence level of the interval}
}

\details{
If only \code{x} is given, or if both \code{x} and \code{y} are given and
\code{paired="TRUE"}, a Wilcoxon signed rank test of the null hypothesis 
that the distribution of \code{x} (in the one sample case) or of 
\code{x - y} (in the paired two sample case) is symmetric about 
\code{mu} is performed.

Otherwise, if both \code{x} and \code{y} are given and \code{paired="FALSE"},
a Wilcoxon rank sum test is done.  In this case, the null
hypothesis is that the distributions of \code{x} and \code{y} differ by a
location shift of \code{mu} and the alternative is that they differ by some other
location shift (and the one-sided alternative \code{"greater"} is that
\code{x} is shifted to the right of \code{y}).

}
\value{
A list with class \code{htest} containing the following components:
  \item{statistic}{ the value of the test statistic with a name describing it}
  \item{p.value}{the p-value for the test}
  \item{null.value}{the location parameter \code{mu}}
  \item{alternative}{a character string describing the alternative hypothesis}
  \item{method}{the type of test applied}
  \item{data.name}{ a character string giving the names of the data}
  \item{conf.int}{a confidence interval for the location parameter}
  \item{estimate}{an estimate of the location parameter}
}

\references{
Gibbons, J.D. and Chakraborti, S. (1992).
\emph{Nonparametric Statistical Inference}. Marcel Dekker Inc., New York.

Myles Hollander & Douglas A. Wolfe (1999), \emph{Nonparametric
Statistical Inference}. New York: John Wiley & Sons.
}

\author{Alan T. Arnholt}

\note{The function is rather primitive and should only be used for problems
with fewer than 19 observations as the memory requirements are rather large.}

\seealso{\code{\link{wilcox.test}}}

\examples{
# Wilcoxon Signed Rank Test - Example 10.3
PH <- c(7.2,7.3,7.3,7.4)
wilcoxE.test(PH, mu=7.25, alternative="greater")
# Wilcoxon Signed Rank Test (Dependent Samples) - Example 10.5 part c.
attach(Aggression)
wilcoxE.test(violence,noviolence,paired=TRUE,alternative="greater")
detach(Aggression)
# Wilcoxon Rank Sum Test - Example 10.7
x <- c(7.2,7.2,7.3,7.3)
y <- c(7.3,7.3,7.4,7.4)
wilcoxE.test(x,y)
}

\keyword{htest}

