% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMSetAttribute}
\alias{PCMSetAttribute}
\title{Set an attribute of a named member in a PCM or other named list object}
\usage{
PCMSetAttribute(
  name,
  value,
  object,
  member = "",
  spec = TRUE,
  inplace = TRUE,
  ...
)
}
\arguments{
\item{name}{a character string denoting the attribute name.}

\item{value}{the value for the attribute.}

\item{object}{a PCM or a list object.}

\item{member}{a member expression. Member expressions are character strings
denoting named elements in a list object (see examples). Default: "".}

\item{spec}{a logical (TRUE by default) indicating if the attribute should
also be set in the corresponding member of the spec attribute (this is for
PCM objects only).}

\item{inplace}{logical (TRUE by default) indicating if the attribute should
be set to the object in the current environment, or a modified object should
be returned.}

\item{...}{additional arguments passed to \code{\link{MatchListMembers}}.}
}
\value{
if inplace is TRUE (default) nothing is returned. Otherwise, a
modified version of object is returned.
}
\description{
Set an attribute of a named member in a PCM or other named list object
}
\details{
Calling this function can affect the attributes of multiple members
matched by the \code{member} argument.
}
\examples{
model <- PCMBaseTestObjects$model_MixedGaussian_ab
PCMSetAttribute("class", c("MatrixParameter", "_Fixed"), model, "H")
}
