% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathEfront.R
\name{mathEfront}
\alias{mathEfront}
\title{Efficient Frontiers from Returns}
\usage{
mathEfront(
  returns,
  mu.max = NULL,
  sigma.max = NULL,
  rf = 0.003,
  rf.line = TRUE,
  stocks = TRUE,
  stock.names = TRUE,
  SRvalue = TRUE,
  npoints = 100,
  cexText = 0.8,
  cexPoints = 0.8,
  digits = NULL
)
}
\arguments{
\item{returns}{Multivariate xts object of portfolio returns}

\item{mu.max}{Numeric value, default NULL}

\item{sigma.max}{Numeric value, default NULL}

\item{rf}{Numeric value with default 0.003}

\item{rf.line}{Logical variable with default TRUE}

\item{stocks}{Logical variable with default TRUE}

\item{stock.names}{Logical variable with default TRUE}

\item{SRvalue}{Logical variable with default TRUE}

\item{npoints}{Integer number of efficient frontier points, default 100}

\item{cexText}{Character expansion factor for text}

\item{cexPoints}{Expansion factor for points}

\item{digits}{Integer variable number of significant digits, default NULL}
}
\value{
No value returned, instead a plot is displayed of the efficient frontier with
cash and risky assets, with risky assets only efficient frontier overlaid
}
\description{
Computes and plots the efficient frontier with and without 
risk-free asset, using a multivariate time series of returns to compute
the mean vector and covariance matrix
}
\details{
When rf.line = TRUE, the linear efficient frontier is displayed,
and it is not displayed when rf.line = FALSE.
When values = TRUE, the Sharpe ratio and risk-free rate values are displayed
in the plot as SHARPE RATIO and RISK-FREE values.
}
\examples{
args(mathEfront)
}
