% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/55_HELPERS_.R
\name{encode.woe}
\alias{encode.woe}
\title{Encode WoE}
\usage{
encode.woe(x, mapping)
}
\arguments{
\item{x}{Character vector to be re-coded.}

\item{mapping}{Data frame with compulsory columns: \code{x.mod} and \code{x.woe} which represents the mapping
scheme. Column \code{x.mod} should contain unique values of original vector \code{x}, while \code{x.woe}
should contain corresponding mapping values.}
}
\value{
The command \code{encode.woe} returns vector of re-coded WoE values.
}
\description{
\code{encode.woe} implements replacement of character vector values with WoE values for a given mapping scheme.
This procedure is one of the helper functions which are handy for the model monitoring phase
(i.e. after model implementation).
}
\examples{
suppressMessages(library(PDtoolkit))
data(gcd)
mbin <- cum.bin(x = gcd$maturity, y = gcd$qual, sc.method = "together")
mbin[[1]]
table(mbin[[2]], useNA = "always")
gcd$x.mod <- mbin[[2]]
woe.rep <- replace.woe(db = gcd[, c("qual", "x.mod")], target = "qual")
gcd$x.woe <- woe.rep[[1]]$x
mapping <- data.frame(x.mod = gcd$x.mod, x.woe = gcd$x.woe)\%>\%
     group_by(x.mod, x.woe) \%>\%
     summarise(n = n(), .groups = "drop")
mapping <- data.frame(mapping[, -3])
ewoe <- encode.woe(x = gcd$x.mod, mapping = mapping)
identical(ewoe, woe.rep[[1]]$x)
}
