% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEnrichment.R
\name{plotEnrichment}
\alias{plotEnrichment}
\title{Plot and match singular enrichment results}
\usage{
plotEnrichment(x, y = NULL, sig.level = 0.05, number.rep = NULL)
}
\arguments{
\item{x}{A data frame that contains singular enrichment results generated by \code{\link{runEnrichment}}}

\item{y}{Default value is NULL. If provided by a singular enrichment results, the matching results
of x and y are plotted.}

\item{sig.level}{The significance level to select post-translational modification (based on their
corrected p-value). Note that \code{sig.level} applies to both x and y simultaneously.}

\item{number.rep}{Only plot PTM terms that occurred more than a specific number of times in UniProt database.
This number is set by number.rep parameter. The default value is NULL.}
}
\value{
Plot.
}
\description{
This function can be used to plot results of singular enrichment analysis for one set of protein.
It can also be used to integrate and match the results of two separate singular enrichment analysis and
plot the common PTMs. For more details please see examples.
}
\examples{
## Enrichment analysis for the first protein list
enrich1 <- runEnrichment(protein = exmplData1$pl1, os.name = 'Homo sapiens (Human)')
## Plot results for first protein list
plotEnrichment(x = enrich1)

## Enrichment analysis for the second protein list
enrich2 <- runEnrichment(protein = exmplData1$pl2, os.name = 'Homo sapiens (Human)')
## Plot results for second protein list
plotEnrichment(x = enrich2)

## Integrate and match the results of two separate singular enrichment analysis
plotEnrichment(x = enrich1, y = enrich2)
plotEnrichment(x = enrich1, y = enrich2, number.rep = 100)
}
