% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoubleMetaphone.R
\encoding{UTF-8}
\name{DoubleMetaphone}
\alias{DoubleMetaphone}
\title{'Double Metaphone' phonetic algorithm}
\usage{
DoubleMetaphone(str)
}
\arguments{
\item{str}{A character vector whose strings are to be encoded by double
metaphone algorithm.}
}
\value{
Returns a list with two character vectors of the same length as the
  input vector. The first character vector contains the primary double
  metaphone encodings, while the second character vector contains the
  alternate encodings.
}
\description{
\code{DoubleMetaphone} converts strings to double metaphone phonetic codes.
}
\details{
An implementation of the Double Metaphone phonetic algorithm in \code{R}. If
non-ASCII characters encountered in the input character vector \code{str}, a
warning is issued and they are transliterated so that the accented characters
are converted to their ASCII unaccented versions.
}
\note{
In case of non-ASCII characters in strings, a warning is issued and
  accented characters are converted to their ASCII unaccented versions.
}
\section{Acknowledgement}{
 The \code{C} code for the double metaphone
  algorithm was adapted from Maurice Aubrey's perl module hosted at the
  \strong{gitpan/Text-DoubleMetaphone}
  \href{https://github.com/gitpan/Text-DoubleMetaphone/blob/master/double_metaphone.c}{public
   github library} along with the corresponding
  \href{https://github.com/gitpan/Text-DoubleMetaphone/blob/master/README}{license
   information}.
}

\examples{
# Return the primary and secondary Double Metaphone encodings for a character vector.
str1 <- c("Jyothi", "Jyoti")
str2 <- c("POLLACHI", "BOLLACHI")
DoubleMetaphone(str1)
DoubleMetaphone(str2)
\dontrun{
# Issue a warning in case of non-ASCII characters.
str3 <- c("J\xf5geva", "Jogeva")
DoubleMetaphone(str3) }
}
\references{
Philips, Lawrence. 2000. "The Double Metaphone Search Algorithm."
  \emph{C/C++ Users Journal} 18 (6): 38-43.
  \url{http://dl.acm.org/citation.cfm?id=349124.349132}.
}
\seealso{
\code{\link[stringdist]{phonetic}},
  \href{https://cran.r-project.org/package=RecordLinkage}{\code{phonetics}}
}
