% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Means.R
\name{phe_mean}
\alias{phe_mean}
\title{Calculate Means using phe_mean}
\usage{
phe_mean(data, x, type = "full", confidence = 0.95)
}
\arguments{
\item{data}{a data.frame containing the data to calculate means for, pre-grouped if multiple means required; unquoted string; no default}

\item{x}{field name from data containing the values to calculate the means for; unquoted string; no default}

\item{type}{defines the data and metadata columns to be included in output;
can be "value", "lower", "upper", "standard" (for all data) or "full" (for all data and metadata); quoted string; default = "full"}

\item{confidence}{the required level of confidence expressed as a number between 0.9 and 1
or a number between 90 and 100 or can be a vector of 0.95 and 0.998, for example, to output both 95\% and 99.8\% CIs;
numeric; default 0.95}
}
\value{
When type = "full", returns a data.frame of value_sum, value_count, stdev, value, lowercl, uppercl, confidence, statistic and method
        for each grouping set
}
\description{
Calculates means with confidence limits using Student's t-distribution method.
}
\examples{
library(dplyr)
df <- data.frame(values = c(30,40,50,60))

## default execution
phe_mean(df, values)

## calculate 95\% and 99.8\% CIs in single execution
phe_mean(df, values, confidence = c(0.95, 0.998))

## calculate multiple means in a single execution

df2 <- data.frame(area = rep(c("Area1", "Area2"),each=3),
                  values = c(20,30,40,200,300,400)) \%>\%
                  group_by(area)
phe_mean(df2,values)
phe_mean(df2,values,type="standard", confidence=0.998)


}
\seealso{
Other PHEindicatormethods package functions: 
\code{\link{phe_dsr}()},
\code{\link{phe_isr}()},
\code{\link{phe_life_expectancy}()},
\code{\link{phe_proportion}()},
\code{\link{phe_quantile}()},
\code{\link{phe_rate}()},
\code{\link{phe_sii}()},
\code{\link{phe_smr}()}
}
\concept{PHEindicatormethods package functions}
