% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_mpin.layers.R
\name{detecting-layers}
\alias{detecting-layers}
\alias{detectlayers_ecm}
\alias{detectlayers_e}
\alias{detectlayers_eg}
\title{Layer detection in trade-data}
\usage{
detectlayers_e(data, confidence = 0.995, correction = TRUE)

detectlayers_eg(data, confidence = 0.995)

detectlayers_ecm(data, hyperparams = list())
}
\arguments{
\item{data}{A dataframe with 2 variables: the first
corresponds to buyer-initiated trades (buys), and the second corresponds
to seller-initiated trades (sells).}

\item{confidence}{A number from \verb{(0.5,1)}, corresponding to the
range of the confidence interval used to determine whether a given cluster is
compact, and therefore can be considered an information layer.
If all values of absolute order imbalances (AOI) within a given cluster are
within the confidence interval of a Skellam distribution with level equal to
\code{'confidence'}, and centered on the mean of AOI, then the cluster is considered
compact, and, therefore, an information layer. If some observations
are outside the confidence interval, then the data is clustered further. The
default value is \code{0.995}. \verb{[i]} This is an argument of the functions
\code{detectlayers_e()}, and \code{detectlayers_eg()}.}

\item{correction}{A binary variable that determines whether the
data will be adjusted prior to implementing the algorithm of
\insertCite{Ersan2016;textual}{PINstimation}. The default value is \code{TRUE}.}

\item{hyperparams}{A list containing the hyperparameters of the \code{ECM}
algorithm. When not empty, it contains one or more of the following
elements: \code{maxeval}, \code{tolerance}, \code{maxinit}, and \code{maxlayers}. More
about these elements are found in the Details section. \verb{[i]} This is
an argument of the function \code{detectlayers_ecm()}.}
}
\value{
Returns an integer corresponding to the number of layers detected in
the data.
}
\description{
Detects the number of information layers present in trade-data
using the algorithms in \insertCite{Ersan2016;textual}{PINstimation},
\insertCite{Ersan2022a;textual}{PINstimation},
and \insertCite{Ghachem2022;textual}{PINstimation}.
}
\details{
The argument 'data' should be a numeric dataframe, and contain
at least two variables. Only the first two variables will be considered:
The first variable is assumed to correspond to the total number of
buyer-initiated trades, while the second variable is assumed to
correspond to the total number of seller-initiated trades. Each row or
observation correspond to a trading day. \code{NA} values will be ignored.

The argument \code{hyperparams}  contains the hyperparameters of the \code{ECM}
algorithm. It is either empty or contains one or more of the following
elements:
\itemize{
\item \code{maxeval}: (\code{integer}) It stands for maximum number of iterations
of the \code{ECM}  for each initial parameter set. When missing, \code{maxeval}
takes the default value of \code{100}.

\item \code{tolerance} (\code{numeric}) The \code{ECM} algorithm is stopped when the
(relative) change of log-likelihood is smaller than tolerance. When
missing, \code{tolerance} takes the default value of \code{0.001}.

\item \code{maxinit}: (\code{integer}) It is the maximum number of initial
parameter sets used for the \code{ECM} estimation per layer. When missing,
\code{maxinit} takes the default value of \code{20}.

\item \code{maxlayers} (\code{integer}) It is the upper limit of number of layers
used in the ECM algorithm. To find the optimal number of layers, the ECM
algorithm will estimate a model for each value of the number of layers
between \code{1} and \code{maxlayers}, and then picks the model that has the lowest
Bayes information criterion (BIC). When missing, \code{maxlayers} takes the
default value of \code{8}.

}
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# Detect the number of layers present in the dataset 'dailytrades' using the
# different algorithms and display the results

e.layers <- detectlayers_e(xdata)
eg.layers <- detectlayers_eg(xdata)
\donttest{em.layers <- detectlayers_ecm(xdata)

show(c(e = e.layers, eg = eg.layers, em = em.layers))}

}
\references{
\insertAllCited
}
