% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclude.R
\name{exclude}
\alias{exclude}
\alias{exclude.PKNCAconc}
\alias{exclude.PKNCAdose}
\alias{exclude.PKNCAresults}
\title{Exclude data points or results from calculations or summarization.}
\usage{
exclude(object, reason, mask, FUN)

\method{exclude}{PKNCAconc}(object, reason, mask, FUN)

\method{exclude}{PKNCAdose}(object, reason, mask, FUN)

\method{exclude}{PKNCAresults}(object, reason, mask, FUN)
}
\arguments{
\item{object}{The object to exclude data from.}

\item{reason}{The reason to add as a reason for exclusion.}

\item{mask}{A logical vector or numeric index of values to exclude 
(see details).}

\item{FUN}{A function to operate on the data to select reasons for 
exclusions (see details).}
}
\value{
The object with updated information in the exclude column. 
  The exclude column will contain the \code{reason} if \code{mask} or
  \code{FUN} indicate.  If a previous reason for exclusion was given,
  then subsequent reasons for exclusion will be added to the first
  with a semicolon space ("; ") separator.
}
\description{
Exclude data points or results from calculations or summarization.
}
\details{
Only one of \code{mask} or \code{FUN} may be given.  If 
  \code{FUN} is given, it will be called on the object as 
  \code{FUN(object)} and it must return a logical vector equivalent 
  to \code{mask}.
}
\examples{
myconc <- PKNCAconc(data.frame(subject=1,
                               time=0:6,
                               conc=c(1, 2, 3, 2, 1, 0.5, 0.25)),
                    conc~time|subject)
exclude(myconc,
        reason="Carryover",
        mask=c(TRUE, rep(FALSE, 6)))
}

