% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThreeComp_Coefficient_Exponent.R
\name{ThreeComp_Coefficient_Exponent}
\alias{ThreeComp_Coefficient_Exponent}
\title{Convert pharmacokinetic parameters for three compartment model}
\usage{
ThreeComp_Coefficient_Exponent(A,B,C,alpha,beta,gamma,A.sd=NA,
   B.sd=NA,C.sd=NA,alpha.sd=NA,beta.sd=NA,gamma.sd=NA,
   covar=c(AB=NA,AC=NA,Aalpha=NA,Abeta=NA,Agamma=NA,BC=NA,Balpha=NA,
   Bbeta=NA,Bgamma=NA,Calpha=NA,Cbeta=NA,Cgamma=NA,alphabeta=NA,
   alphagamma=NA,betagamma=NA))
}
\arguments{
\item{A}{parameter in one compartment model "Aexp(-alpha)"}

\item{B}{parameter in two compartment model "Aexp(-alpha)+Bexp(-beta)"}

\item{C}{parameter in three compartment model
"Aexp(-alpha)+Bexp(-beta)+Cexp(-gamma)"}

\item{alpha}{parameter in one compartment model "Aexp(-alpha)"}

\item{beta}{parameter in two compartment model "Aexp(-alpha)+Bexp(-beta)"}

\item{gamma}{parameter in three compartment model
"Aexp(-alpha)+Bexp(-beta)+Cexp(-gamma)"}

\item{A.sd}{standard error of A}

\item{B.sd}{standard error of B}

\item{C.sd}{standard error of C}

\item{alpha.sd}{standard error of alpha}

\item{beta.sd}{standard error of beta}

\item{gamma.sd}{standard error of gamma}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with parameters (A, B, C,
alpha, beta, and gamma) in two compartment model
"Aexp(-alpha)+Bexp(-beta)+Cexp(-gamma)"
}
\examples{
ThreeComp_Coefficient_Exponent(A=12.2,B=3.76,C=1.44,
alpha=0.870,beta=0.12,gamma=0.013, A.sd=0.2,B.sd=0.005,C.sd=0.0005,
alpha.sd=0.009,beta.sd=0.006,gamma.sd=0.00005)
}
\references{
\url{www.nonmemcourse.com/convert.xls}
}
