% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNmodels-package.R
\docType{package}
\name{PLNmodels}
\alias{PLNmodels}
\title{PLNmodels}
\description{
The Poisson lognormal model and variants can be used for a variety of multivariate problems when count data are at play (including
PCA or LDA for count data, network inference). This package implements efficient
variational algorithms to fit such models accompanied with a set of functions for visualization and diagnostic.
}
\section{Multivariate Poisson lognormal model (aka PLN)}{


See the main function \code{\link[=PLN]{PLN()}} and the associated methods for manipulation.

Also try vignette("PLN_trichoptera", package="PLNmodels") for an overview.
}

\section{Rank Constrained Poisson lognormal for Poisson Principal Component Analysis (aka PLNPCA)}{


See the main function \code{\link[=PLNPCA]{PLNPCA()}} and the associated methods for manipulation.

The Poisson PCA and the associated variational inference is fully explained in Chiquet el al (2018), see reference below.

Also try vignette("PLNPCA_trichoptera", package="PLNmodels") for an overview.
}

\section{Sparse Poisson lognormal model for sparse covariance inference for counts (aka PLNnetwork)}{


See the main function \code{\link[=PLNnetwork]{PLNnetwork()}} and the associated methods for manipulation.

Also try vignette("PLNnetwork_trichoptera", package="PLNmodels") for an overview.
}

\section{Poisson lognormal discriminant analysis (aka PLNLDA)}{


See the main function \code{\link[=PLNLDA]{PLNLDA()}} and the associated methods for manipulation.

Also try vignette("PLNLDA_trichoptera", package="PLNmodels") for an overview.
}

\author{
Julien Chiquet \email{julien.chiquet@inrae.fr}

Mahendra Mariadassou \email{mahendra.mariadassou@inrae.fr}

Stéphane Robin \email{stephane.robin@inrae.fr}
}
