% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfamily-S3methods.R
\name{plot.PLNnetworkfamily}
\alias{plot.PLNnetworkfamily}
\title{Display various outputs (goodness-of-fit criteria, robustness, diagnostic) associated with a collection of PLNnetwork fits (a \code{\link{PLNnetworkfamily}})}
\usage{
\method{plot}{PLNnetworkfamily}(
  x,
  type = c("criteria", "stability", "diagnostic"),
  criteria = c("loglik", "pen_loglik", "BIC", "EBIC"),
  reverse = FALSE,
  log.x = TRUE,
  stability = 0.9,
  ...
)
}
\arguments{
\item{x}{an R6 object with class \code{\link{PLNnetworkfamily}}}

\item{type}{a character, either "criteria", "stability" or "diagnostic" for the type of plot.}

\item{criteria}{vector of characters. The criteria to plot in c("loglik", "BIC", "ICL", "R_squared", "EBIC", "pen_loglik").
Default is  c("loglik", "pen_loglik", "BIC", "EBIC"). Only relevant when \code{type = "criteria"}.}

\item{reverse}{A logical indicating whether to plot the value of the criteria in the "natural" direction
(loglik - 0.5 penalty) or in the "reverse" direction (-2 loglik + penalty). Default to FALSE, i.e use the
natural direction, on the same scale as the log-likelihood.}

\item{log.x}{logical: should the x-axis be represented in log-scale? Default is \code{TRUE}.}

\item{stability}{scalar: the targeted level of stability in stability plot. Default is .9.}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
Produces either a diagnostic plot (with \code{type = 'diagnostic'}), a stability plot
(with \code{type = 'stability'}) or the evolution of the criteria of the different models considered
(with \code{type = 'criteria'}, the default).
}
\description{
Display various outputs (goodness-of-fit criteria, robustness, diagnostic) associated with a collection of PLNnetwork fits (a \code{\link{PLNnetworkfamily}})
}
\details{
The BIC and ICL criteria have the form 'loglik - 1/2 * penalty'
so that they are on the same scale as the model log-likelihood. You can change this direction and use the alternate form '-2*loglik + penalty', as some authors do, by setting \code{reverse = TRUE}.
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
\dontrun{
plot(fits)
}
}
