% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSTTest.R
\name{GSTTest}
\alias{GSTTest}
\alias{GSTTest.default}
\alias{GSTTest.formula}
\title{Generalized Siegel-Tukey Test of Homogeneity of
Scales}
\usage{
GSTTest(x, ...)

\method{GSTTest}{default}(x, g, dist = c("Chisquare", "KruskalWallis"), ...)

\method{GSTTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  dist = c("Chisquare", "KruskalWallis"),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{dist}{the test distribution. Defaults's to \code{"Chisquare"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs a Siegel-Tukey k-sample rank dispersion test.
}
\details{
Meyer-Bahlburg (1970) has proposed a generalized Siegel-Tukey
rank dispersion test for the \eqn{k}-sample case.
Likewise to the \code{\link{fligner.test}}, this test
is a nonparametric test for testing the homogegeneity of
scales in several groups.
Let \eqn{\theta_i}{theta_i}, and \eqn{\lambda_i}{lambda_i} denote
location and scale parameter of the \eqn{i}th group,
then for the two-tailed case, the null hypothesis
H: \eqn{\lambda_i / \lambda_j = 1 | \theta_i = \theta_j, ~ i \ne j}{%
 lambda_i / lambda_j = 1 | theta_i = theta_j, i != j} is
tested against the alternative,
A: \eqn{\lambda_i / \lambda_j \ne 1}{lambda_i / lambda_j != 1}
with at least one inequality beeing strict.

The data are combinedly ranked according to Siegel-Tukey.
The ranking is done by alternate extremes (rank 1 is lowest,
2 and 3 are the two highest, 4 and 5 are the two next lowest, etc.).

Meyer-Bahlburg (1970) showed, that the Kruskal-Wallis H-test
can be employed on the Siegel-Tukey ranks.
The H-statistic is assymptotically
chi-squared distributed with \eqn{v = k - 1} degree
of freedom, the default test distribution is consequently
\code{dist = "Chisquare"}. If \code{dist = "KruskalWallis"} is selected,
an incomplete beta approximation is used for the calculation
of p-values as implemented in the function
\code{\link[SuppDists]{pKruskalWallis}} of the package
\pkg{SuppDists}.
}
\note{
If ties are present, a tie correction is performed and
a warning message is given. The GSTTest is sensitive to
median differences, likewise to the Siegel-Tukey test.
It is thus appropriate to apply this test on the residuals
of a one-way ANOVA, rather than on the original data
(see example).
}
\examples{
GSTTest(count ~ spray, data = InsectSprays)

## as means/medians differ, apply the test to residuals
## of one-way ANOVA
ans <- aov(count ~ spray, data = InsectSprays)
GSTTest( residuals( ans) ~ spray, data =InsectSprays)

}
\references{
H.F.L. Meyer-Bahlburg (1970), A nonparametric test for relative
spread in k unpaired samples, \emph{Metrika} \bold{15}, 23--29.
}
\seealso{
\code{\link{fligner.test}}, \code{\link[SuppDists]{pKruskalWallis}},
\code{\link{Chisquare}}, \code{\link{fligner.test}}
}
\keyword{htest}
\keyword{nonparametric}
