% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDAopt.R
\name{PDAopt}
\alias{PDAopt}
\title{PP optimization using PDA index}
\usage{
PDAopt(origclass,origdata,q=1,weight=TRUE,lambda=0.1,...)
}
\arguments{
\item{origclass}{class information vector of data}

\item{origdata}{data matrix without class information}

\item{q}{dimension of projection vector}

\item{weight}{weight flag in PDA index}

\item{lambda}{lambda in PDA index}

\item{...}{arguments to be passed to methods}
}
\value{
indexbest maximum PDA index value

projbest optimal q-dimensional projection matrix

origclass original class information vector

origdata  original data matrix without class information
}
\description{
PP optimization using PDA index
}
\details{
Find the q-dimensional optimal projection using PDA projectin pursuit index
}
\examples{
data(iris)
PDA.proj.result <- PDAopt(iris[,5],iris[,1:4],weight=TRUE,q=2,lambda=0.1)
PDA.proj.result$indexbest
PDA.proj.result$projbest
}
\references{
Lee, EK, Cook, D.(2010) 
A Projection Pursuit Index for Large p Small n Data, 
Statistics and Computing, 20:381-392.
}
\keyword{projection}
\keyword{pursuit}

