\name{predict.sbh}

\alias{predict.sbh}

\alias{predict}

\title{Predict Function}

\description{
  S3-method \code{predict} function to predict the box membership and box vertices 
  on an independent set, using a cross-validated \code{sbh} fitted object.
}

\usage{
  \method{predict}{sbh}(object, 
        newdata, 
        steps = 1:object$cvfit$cv.nsteps, 
        na.action = na.omit, ...)
}

\arguments{
  \item{object}{
    Object of class \code{sbh} as generated by the main function \code{\link[PRIMsrc]{sbh}}.
  }
  \item{newdata}{
    A numeric matrix containing the new input data of same format as input data \code{object$X}. 
    If not a matrix, \code{newdata} will be coerced to a matrix.
  }
  \item{steps}{
    \code{Integer} \code{vector}. Vector of peeling steps at which to predict the box memberships 
    and box vertices. Defaults to all the peeling steps of \code{sbh} object \code{object}.
  }
  \item{na.action}{
    A function to specify the action to be taken if NAs are found.
    The default action is na.omit, which leads to rejection of incomplete cases.
  }
 \item{\dots}{
    Further generic arguments passed to the predict function.
  }
}

\details{
    Only the used covariates of the final \code{sbh} object will be retained for the covariates of \code{newdata}. 
    So, the used covariates of \code{sbh} object must be equal or a subset of the 
    the covariates of \code{newdata}.
}

\value{
  \code{List} containing the following 5 fields:
    \item{boxind}{\code{Logical} \code{matrix} of predicted box membership indicator (columns) by peeling steps (rows).
    TRUE = inbox, FALSE = outbox.}
    \item{vertices}{\code{List} of size the number of chosen peeling steps, where each entry is a \code{numeric} \code{matrix} of 
    predicted box vertices: lower and upper bounds (rows) by covariate (columns).}
    \item{rules}{\code{List} of size the number of chosen peeling steps, where each entry is a \code{numeric} \code{matrix} of 
    decision rules on the covariates (columns) for all peeling steps (rows).}
    \item{sign}{\code{numeric} \code{vector} in \{-1,+1\} of directions of peeling for all used (selected) covariates.}
    \item{used}{\code{numeric} \code{vector} of covariates used (selected) for peeling, indexed in reference to original index.}   
}

\author{
    \itemize{
        \item "Jean-Eudes Dazard, Ph.D." \email{jean-eudes.dazard@case.edu}
        \item "Michael Choe, M.D." \email{mjc206@case.edu}
        \item "Michael LeBlanc, Ph.D." \email{mleblanc@fhcrc.org}
        \item "Alberto Santana, MBA." \email{ahs4@case.edu}
        \item "J. Sunil Rao, Ph.D." \email{Rao@biostat.med.miami.edu}
    }
    Maintainer: "Jean-Eudes Dazard, Ph.D." \email{jean-eudes.dazard@case.edu}
}

\references{
    \itemize{
        \item Dazard J-E. and Rao J.S. (2018).
              "\emph{Variable Selection Strategies for High-Dimensional Survival Bump Hunting using Recursive Peeling Methods.}"
              (in prep).
        \item Rao J.S., Huilin Y. and Dazard J-E. (2018).
              "\emph{Disparity Subtyping: Bringing Precision Medicine Closer to Disparity Science.}"
              (in prep).
        \item Diaz-Pachon D.A., Saenz J.P., Dazard J-E. and Rao J.S. (2018).
              "\emph{Mode Hunting through Active Information.}"
              (in press).
        \item Diaz-Pachon D.A., Dazard J-E. and Rao J.S. (2017).
              "\emph{Unsupervised Bump Hunting Using Principal Components.}"           
              In: Ahmed SE, editor. Big and Complex Data Analysis: Methodologies and Applications. 
              Contributions to Statistics, vol. Edited Refereed Volume. 
              Springer International Publishing, Cham Switzerland, p. 325-345.
        \item Yi C. and Huang J. (2017).
              "\emph{Semismooth Newton Coordinate Descent Algorithm for Elastic-Net Penalized Huber Loss Regression and Quantile Regression}."
              J. Comp Graph. Statistics, 26(3):547-557.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2016).
              "\emph{Cross-validation and Peeling Strategies for Survival Bump Hunting using Recursive Peeling Methods.}"
              Statistical Analysis and Data Mining, 9(1):12-42.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2015).
              "\emph{R package PRIMsrc: Bump Hunting by Patient Rule Induction Method for Survival, Regression and Classification.}"
              In JSM Proceedings, Statistical Programmers and Analysts Section. Seattle, WA, USA.
              American Statistical Association IMS - JSM, p. 650-664.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2014).
              "\emph{Cross-Validation of Survival Bump Hunting by Recursive Peeling Methods.}"
              In JSM Proceedings, Survival Methods for Risk Estimation/Prediction Section. Boston, MA, USA.
              American Statistical Association IMS - JSM, p. 3366-3380.
        \item Dazard J-E. and J.S. Rao (2010).
              "\emph{Local Sparse Bump Hunting.}"
              J. Comp Graph. Statistics, 19(4):900-92.
    }
}

\section{Acknowledgments}{
    This work made use of the High Performance Computing Resource in the Core Facility for Advanced Research Computing at Case Western Reserve University. 
    This project was partially funded by the National Institutes of Health NIH - National Cancer Institute (R01-CA160593) to J-E. Dazard and J.S. Rao.
}

\note{
  End-user predict function.
}

\keyword{Exploratory Survival/Risk Analysis}
\keyword{Survival/Risk Estimation & Prediction}
\keyword{Non-Parametric Method}
\keyword{Cross-Validation}
\keyword{Bump Hunting}
\keyword{Rule-Induction Method}
