% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configPROsetta.R
\docType{class}
\name{loadData}
\alias{loadData}
\alias{PROsetta_data-class}
\title{Load data from supplied config}
\usage{
loadData(
  response,
  itemmap,
  anchor,
  item_id = NULL,
  person_id = NULL,
  scale_id = NULL,
  input_dir = getwd()
)
}
\arguments{
\item{response}{response data containing case IDs and item responses. This can be a \code{.csv} filename or a \code{\link{data.frame}} object.}

\item{itemmap}{an item map containing item IDs and scale IDs. This can be a \code{.csv} filename or a \code{\link{data.frame}} object.}

\item{anchor}{anchor data containing item parameters for anchor items. This can be a \code{.csv} filename or a \code{\link{data.frame}} object.}

\item{item_id}{the column name to look for item IDs. Automatically determined if not specified.}

\item{person_id}{the column name to look for case IDs. Automatically determined if not specified.}

\item{scale_id}{the column name to look for scale IDs. Automatically determined if not specified.}

\item{input_dir}{the directory to look for the files.}
}
\value{
\code{\link{loadData}} returns a \code{\linkS4class{PROsetta_data}} object containing the loaded data.
}
\description{
\code{\link{loadData}} is a data loading function to create a \code{\linkS4class{PROsetta_data}} object, for scale linking/equating with 'PROsetta' package.
}
