% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUTO_PSF.R
\name{AUTO_PSF}
\alias{AUTO_PSF}
\title{AUTO_PSF() takes input data and autogenerate optimum Window size (W) and cluster size (K)}
\usage{
AUTO_PSF(data_in, next_val)
}
\arguments{
\item{data_in}{as Input data, in any format (data matrix data frame or vector). All variables should be numeric and NA values will get removed while execution.}

\item{next_val}{as Integer number. It states the number of predicted values to be obtained.}
}
\value{
Function returns "next_val" numbers of future values and corresponding plot.
}
\description{
Predicts the "next_val" numbers of future values
}
\examples{
## Generate 100 random numbers within some limits
x <- sample(1:7, 100, replace = TRUE)
AUTO_PSF(x, 2)      # next_val = 5

## iris data as input data
AUTO_PSF (iris[2], 4) #next_val = 4
}

