#' @title Survey information data from Pakistan Social and Living Standards Measurement 2015-16 
#' @name   SurveyInfo
#' @docType data
#' @keywords datasets
#' @usage data(SurveyInfo)
#' @description \code{SurveyInfo} Household wise survey information data from Pakistan Social and Living Standards Measurement 2015-16.
#' @format A \code{data.table} and  \code{data.frame} with 24238 obs. of  26 variables.
#' \describe{
#'        \item{\code{hhcode}}{10 digits Household code.}
#'        \item{\code{Province}}{Province of Pakistan}
#'        \item{\code{Region}}{Urban or Rural area of Pakitan}
#'        \item{\code{Psu}}{08 digits code of primary sampling unit}
#'        \item{\code{sec}}{Questionair section}
#'        \item{\code{memno}}{Member no}
#'        \item{\code{EB.CODE}}{Enumeration Block Code}
#'        \item{\code{operator.code}}{Optcode}
#'        \item{\code{batch}}{Batch No}
#'        \item{\code{entrey.date}}{Date of Entry}
#'        \item{\code{time}}{Time of interview}
#'        \item{\code{Enumerator.code}}{Interviewer Code}
#'        \item{\code{Enum.Date}}{Date of Enumeratiom}
#'        \item{\code{Enum.Month}}{Month of Enumeration}
#'        \item{\code{Enum.Year}}{Year of Enumeration}
#'        \item{\code{behaviour}}{Behaviour of the Respondent}
#'        \item{\code{language}}{Language of the interview}
#'        \item{\code{distance}}{Distance of PSU from office}
#'        \item{\code{supervisor}}{Supervisor code}
#'        \item{\code{Check.date}}{Date of Supervision}
#'        \item{\code{Check.month}}{Month of Supervision}
#'        \item{\code{Check.year}}{Year of Supervision}
#'        \item{\code{Editor.code}}{Editor Code}
#'        \item{\code{Edit.Date}}{Date of Editing}
#'        \item{\code{Edit.month}}{Month of Editing}
#'        \item{\code{Edit.year}}{Year of Editing}
#'        }
#'        
#' @author Muhammad Yaseen (\email{myaseen208@gmail.com})
#' @author Muhammad Arfan Dilber (\email{pbsfsd041@gmail.com})
#' 
#' @references \enumerate{
#' \item Pakistan Bureau of Statistics, Micro data (\url{http://www.pbs.gov.pk/}).
#'  }
#'
#' @seealso 
#'    \code{\link{Agriculture}}
#'  , \code{\link{AssetLiability}}
#'  , \code{\link{Education}}
#'  , \code{\link{Employment}}
#'  , \code{\link{Expenditure}}
#'  , \code{\link{ICT}}
#'  , \code{\link{Income}}
#'  , \code{\link{Land}}
#'  , \code{\link{LiveStock}}
#'  , \code{\link{NonAgriculture}}
#'  , \code{\link{OtherIncome}}
#'  , \code{\link{PaidReceived}}
NULL