% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\title{Simulate a population and a randomized trial under PSPI scenarios}
\usage{
sim_data(n_trial = 200, scenario = "linear", seed = NULL, prop = 0.5)
}
\arguments{
\item{n_trial}{Integer. Target trial size; must be \code{200} or \code{60}.}

\item{scenario}{Character. One of \code{"linear"}, \code{"linear+covariate shift"},
\code{"nonlinear"}, \code{"nonlinear+covariate shift"}.}

\item{seed}{Optional integer seed for reproducibility. If \code{NULL}, the current
RNG state is used.}

\item{prop}{Numeric in \code{[0,1]}. Randomization probability \eqn{P(A=1)} within
the trial.}
}
\value{
A \code{list} with two data frames:
\describe{
\item{population}{columns \code{X1:X10}, potential outcomes \code{Y1} and \code{Y0},
\code{selected} (logical), and \code{ps} (true propensity scores of trial participation).}
\item{trials}{columns \code{X1:X10}, \code{A}, and observed \code{Y}.}
}
}
\description{
Generates a finite population of size 1000 with seven continuous and three
binary covariates, constructs potential outcomes \code{Y0} and \code{Y1}
according to the chosen scenario, simulates trial participation through a
logistic selection model calibrated to target \code{n_trial} = 200 or 60,
and returns both the target population and the randomized trial
(with treatment assigned at probability \code{prop}).
}
\examples{
set.seed(2025)
sim <- sim_data(n_trial = 200, scenario = "nonlinear", prop = 0.5)
str(sim$population)
table(sim$trials$A)            # treatment allocation
mean(sim$population$selected)   # selection rate

# A smaller trial size and linear scenario with covariate shift
sim2 <- sim_data(n_trial = 60, scenario = "linear+covariate shift", seed = 1, prop = 0.6)
nrow(sim2$trials)


}
